/*
	MCMultiNibPrintController.h
	
	Created By:	cwhite
				Sun 24-May-1998

*/

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import "MCNibPrintingDefines.h"

@interface MCMultiNibPrintController : NSObject
{
    id					page1Ctl;
    id					pageEvenCtl;
    id					pageOddCtl;
    id					pageDefaultCtl;
    id					pageCtlList;
    id					delegatingPrintView;
	
	NSMutableSet		*configurators;
	id					defaultConfigurator;

    PE_PAGE_SCALING		pageViewScaleModel;
	NSSize				paperClipSize;

    BOOL				showPanels;
    id					(model);
    id					(listModel);
    NSPrintInfo			*_printInfo;
    NSMutableArray		*operationPageCtls;
    NSMutableArray		*operationModelArraysPerPage;
    NSWindow			*ourWindow;
    NSMutableDictionary	*interPageInfo;
    id					delegate;
}

- (void)setModel:aModel;
- (void)setListModel:(NSArray *)anArray;
- (void)setPrintInfo:(NSPrintInfo *)aPrintInfo;

- (NSSet *)configurators;
- (void)addViewConfigurator:(id)aConfig;

- (void)setResizePageViewsToMatchPaper:(PE_PAGE_SCALING)aValue;
- (void)setShowPanels:(BOOL)aValue;
- (NSPrintInfo *)printInfo;

- (BOOL)runOperation;
- (BOOL)runOperationWithModel:aModel andListModel:aListModel;

- (BOOL)prepareForPrintOperation;

- (void)doneWithViewForPage:(int)aPage;

@end

@interface NSObject (MCMultiNibPrintControllerDelegate)

- (void)pageCtl:aPageCtl willPrintModel:aModel andListModel:aList;
- (void)pageCtl:aPageCtl didPrintModel:aModel andListModel:aList;

@end
